<?php
    require_once __DIR__ . '/../config/functions.php';
    require_once __DIR__ . '/../classes/Auth.php';


    function authMiddleware()
    {
        $headers = getallheaders();
    
        if (!isset($headers['Authorization'])) {
            http_response_code(401);
            echo json_encode(['error' => 'Missing Authorization header']);
            exit;
        }
    
        $token = str_replace("Bearer ", "", $headers['Authorization']);
    
        $auth = new Auth();
        $payload = $auth->verifyToken($token);
    
        if (!$payload) {
            http_response_code(401);
            echo json_encode(['error' => 'Invalid or expired token']);
            exit;
        }
    
        // set globally for endpoint access
        $GLOBALS['auth_user'] = $payload;
    
        return $payload;  
    }

