<?php
     // Allow all origins for testing
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Methods: POST, GET, PUT, OPTIONS");
    header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");
    
    // Stop OPTIONS preflight from executing the rest of the script
    if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
        http_response_code(200);
        exit();
    }

    
    // Handle preflight OPTIONS request
    if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
        http_response_code(200);
        exit();
    }


    /**
     * Database Connection File
     * Automatically switches between LOCAL and PRODUCTION DB credentials
     */

    $serverName = $_SERVER['SERVER_NAME'] ?? 'localhost';

    // -------------------------
    // LOCAL ENVIRONMENT
    // -------------------------
    if (
        $serverName === 'localhost' ||
        $serverName === '127.0.0.1' ||
        str_contains($serverName, '.test') ||
        str_contains($serverName, '.local')
    ) {
        $DB_HOST = "localhost";
        $DB_NAME = "reservetransit";
        $DB_USER = "root";
        $DB_PASS = "";
        $DB_DEBUG = true; // show DB errors locally
    }

    // -------------------------
    // PRODUCTION (cPanel)
    // -------------------------
    else {
        $DB_HOST = "localhost"; 
        $DB_NAME = "scoretvc_reserve_transit";
        $DB_USER = "scoretvc_reserve_transit_user";      
        $DB_PASS = "reserveTransitProject@2025";  
        $DB_DEBUG = true; 
    }

    try {
        $db = new PDO(
            "mysql:host={$DB_HOST};dbname={$DB_NAME};charset=utf8mb4",
            $DB_USER,
            $DB_PASS,
            [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION, // Symfony-style exception mode
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false, // Native prepared statements
            ]
        );
    } catch (PDOException $e) {
        if ($DB_DEBUG) {
            die("Database Connection Failed: " . $e->getMessage());
        }
        die("Database connection error. Please try again later.");
    }
