<?php
    require_once __DIR__ . '/../config/functions.php';

    class Trip {
        private $db;

        public function __construct() {
            global $db;
            $this->db = $db;
        }

        public function createTrip(int $fromBranchId, int $toBranchId, string $departureTime, string $arrivalTime, float $price, int $availableSeats): array {
            $stmt = $this->db->prepare("INSERT INTO trips (from_branch_id, to_branch_id, departure_time, arrival_time, price, available_seats, created_at) VALUES (?, ?, ?, ?, ?, ?, ?)");
            $now = date('Y-m-d H:i:s');
            $stmt->execute([$fromBranchId, $toBranchId, $departureTime, $arrivalTime, $price, $availableSeats, $now]);
            $tripId = $this->db->lastInsertId();
            return $this->getTrip($tripId);
        }

    
        // Retrieve trip by ID
        public function getTrip(int $id): array {
            $stmt = $this->db->prepare("SELECT * FROM trips WHERE id = ?");
            $stmt->execute([$id]);
            return $stmt->fetch(PDO::FETCH_ASSOC);
        }


        public function list(int $limit = 50, int $offset = 0): array {
            $stmt = $this->db->prepare("SELECT * FROM trips ORDER BY departure_time DESC LIMIT ? OFFSET ?");
            $stmt->bindValue(1, $limit, PDO::PARAM_INT);
            $stmt->bindValue(2, $offset, PDO::PARAM_INT);
            $stmt->execute();
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        }

        public function update($tripId, $fromBranchId, $toBranchId, $departureTime, $arrivalTime, $price) {
            $stmt = $this->db->prepare("
                UPDATE trips 
                SET from_branch_id = ?, to_branch_id = ?, departure_time = ?, arrival_time = ?, price = ? 
                WHERE id = ?
            ");
            $stmt->execute([$fromBranchId, $toBranchId, $departureTime, $arrivalTime, $price, $tripId]);
            return $this->get($tripId); // Return updated trip details
        }


        public function delete(int $id): bool {
            $stmt = $this->db->prepare("DELETE FROM trips WHERE id = ?");
            return $stmt->execute([$id]);
        }

        public function count() {
            global $db;
            $stmt = $db->query("SELECT COUNT(*) as total FROM trips");
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            return (int)$row['total'];
        }

        public function today() {
            global $db;
            $today = date('Y-m-d');
            $stmt = $db->prepare("SELECT * FROM trips WHERE DATE(departure_date) = ?");
            $stmt->execute([$today]);
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        }
    }
