<?php
    require_once __DIR__ . '/../config/functions.php';

    class Feedback {
        private $db;

        public function __construct() {
            global $db;
            $this->db = $db;
        }

        public function createFeedback(array $data): array {
            $required = ['name','email','type','message'];
        
            foreach ($required as $field) {
                if (!isset($data[$field]) || trim($data[$field]) === '') {
                    throw new Exception("Missing field: $field");
                }
            }
        
            // Spam check
            if (!empty($data['website'])) {
                throw new Exception("Spam detected");
            }
        
            $stmt = $this->db->prepare("
                INSERT INTO feedback
                (name, email, phone, rating, type, shipment_number, website, message, created_at, updated_at)
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW(), NOW())
            ");
        
            $stmt->execute([
                $data['name'],
                $data['email'],
                $data['phone'] ?? null,
                $data['rating'] ?? null,
                $data['type'],
                $data['shipment_number'] ?? null,
                $data['website'] ?? null,
                $data['message']
            ]);
        
            return ['id' => $this->db->lastInsertId()];
        }
        
        public function getById(int $id): array {
            $stmt = $this->db->prepare("SELECT * FROM bookings WHERE id = ?");
            $stmt->execute([$id]);
            return $stmt->fetch(PDO::FETCH_ASSOC);
        }

        public function getAll(): array {
            $stmt = $this->db->query("SELECT * FROM feedback ORDER BY created_at DESC");
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        }
        
        public function updateStatus(int $id, string $status, ?string $notes = null): array
        {
            $valid = ['new', 'in_review', 'resolved'];
        
            if (!in_array($status, $valid, true)) {
                throw new Exception("Invalid status value");
            }
        
            // Make sure feedback exists
            $stmt = $this->db->prepare("SELECT * FROM feedback WHERE id = ?");
            $stmt->execute([$id]);
            $item = $stmt->fetch(PDO::FETCH_ASSOC);
        
            if (!$item) {
                throw new Exception("Feedback not found");
            }
        
            // Update the status and notes
            $stmt = $this->db->prepare("
                UPDATE feedback 
                SET status = ?, message = ?, updated_at = ? 
                WHERE id = ?
            ");
        
            $now = date('Y-m-d H:i:s');
            $stmt->execute([$status, $notes, $now, $id]);
        
            // Return updated row
            $stmt2 = $this->db->prepare("SELECT * FROM feedback WHERE id = ?");
            $stmt2->execute([$id]);
        
            return $stmt2->fetch(PDO::FETCH_ASSOC);
        }

    }
