<?php
    class Dashboard {
        public function getStats(): array {
            $trips = $this->db->query("SELECT COUNT(*) as total_trips FROM trips")->fetch(PDO::FETCH_ASSOC);
            $bookings = $this->db->query("SELECT COUNT(*) as total_bookings FROM bookings")->fetch(PDO::FETCH_ASSOC);
            $revenue = $this->db->query("SELECT SUM(amount) as total_revenue FROM bookings WHERE status='paid'")->fetch(PDO::FETCH_ASSOC);
        
            return [
                'total_trips' => (int)$trips['total_trips'],
                'total_bookings' => (int)$bookings['total_bookings'],
                'total_revenue' => (float)$revenue['total_revenue']
            ];
        }

    }