<?php
    require_once __DIR__ . '/../config/functions.php';

    class Branch {
        private $db;
    
        public function __construct() {
            global $db;
            $this->db = $db;
        }
    
        // Create a new branch
        public function create(string $name, string $location, string $createdById): array {
            $stmt = $this->db->prepare("INSERT INTO branches (name, location, created_by) VALUES (?, ?, ?)");
            $stmt->execute([$name, $location, $createdById]);
            return $this->get($this->db->lastInsertId());
        }
    
    
        // List branches with optional pagination
        public function list(int $limit = 50, int $offset = 0): array {
            $stmt = $this->db->prepare("SELECT * FROM branches ORDER BY id DESC LIMIT ? OFFSET ?");
            $stmt->bindValue(1, $limit, PDO::PARAM_INT);
            $stmt->bindValue(2, $offset, PDO::PARAM_INT);
            $stmt->execute();
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        }
        
        // Update a branch
        public function update(int $branchId, string $name, string $location): array {
            $stmt = $this->db->prepare("UPDATE branches SET name = ?, location = ? WHERE id = ?");
            $stmt->execute([$name, $location, $branchId]);
            
            return $this->get($branchId); 
        }
        
        // Optional: Get a single branch
        public function get(int $branchId): array {
            $stmt = $this->db->prepare("SELECT * FROM branches WHERE id = ?");
            $stmt->execute([$branchId]);
            $branch = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if (!$branch) {
                throw new Exception("Branch not found");
            }
            
            return $branch;
        }
        
        public function delete(int $branchId): bool {
            $stmt = $this->db->prepare("DELETE FROM branches WHERE id = ?");
            $stmt->execute([$branchId]);
            
            return true; 
        }
    }
