<?php
    require_once __DIR__ . '/../../config/functions.php';
    require_once __DIR__ . '/../../classes/Shipment.php';
    require_once __DIR__ . '/../../middlewares/auth.php';
    
    authMiddleware();
    
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($input['shipment_id'], $input['status'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Invalid request body']);
        exit;
    }
    
    $note = $input['note'] ?? '';
    
    $shipment = new Shipment();
    try {
        $updated = $shipment->updateStatus((int)$input['shipment_id'], $input['status'], $note);
        echo json_encode($updated);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to update status', 'message' => $e->getMessage()]);
    }
