<?php
    require_once __DIR__ . '/../../config/functions.php';
    require_once __DIR__ . '/../../classes/Shipment.php';
    require_once __DIR__ . '/../../middlewares/auth.php';
    
    authMiddleware();
    
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($input['shipment_id'], $input['event_type'], $input['event_message'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Invalid request body']);
        exit;
    }
    
    $shipment = new Shipment();
    try {
        $event = $shipment->addEvent((int)$input['shipment_id'], $input['event_type'], $input['event_message']);
        http_response_code(201);
        echo json_encode($event);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to add event', 'message' => $e->getMessage()]);
    }
