<?php
    require_once __DIR__ . '/../../config/functions.php';
    require_once __DIR__ . '/../../classes/Shipment.php';
    require_once __DIR__ . '/../../middlewares/auth.php';
    
    authMiddleware();
    $shipment = new Shipment();
    
    try {
        $s = $shipment->listShipments();
        if (!$s) {
            http_response_code(404);
            echo json_encode(['error' => 'No Shipments yet.']);
            exit;
        }
        echo json_encode($s);
        
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to load shipment', 'message' => $e->getMessage()]);
    }
