<?php
    require_once __DIR__ . '/../../config/functions.php';
    require_once __DIR__ . '/../../classes/Shipment.php';
    require_once __DIR__ . '/../../middlewares/auth.php';
    
    authMiddleware();
    
    $id = $_GET['id'] ?? null;
    if (!$id) {
        http_response_code(400);
        echo json_encode(['error' => 'Missing shipment id']);
        exit;
    }
    
    $shipment = new Shipment();
    try {
        $s = $shipment->getShipmentById((int)$id);
        if (!$s) {
            http_response_code(404);
            echo json_encode(['error' => 'Shipment not found']);
            exit;
        }
        // include events
        $s['events'] = $shipment->getEvents((int)$id);
        echo json_encode($s);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to load shipment', 'message' => $e->getMessage()]);
    }
