<?php
    require_once __DIR__ . '/../../config/functions.php';
    require_once __DIR__ . '/../../classes/Shipment.php';
    require_once __DIR__ . '/../../middlewares/auth.php';
    
    // Admin auth
    authMiddleware();
    
    $input = json_decode(file_get_contents('php://input'), true);
    
    $required = [
        'sender_name',
        'sender_address',
        'recipient_name',
        'recipient_address',
        'recipient_email',
        'contents'
    ];
    
    foreach ($required as $r) {
        if (!isset($input[$r])) {
            http_response_code(400);
            echo json_encode(['error' => "Missing field: $r"]);
            exit;
        }
    }
    
    $shipment = new Shipment();
    
    try {
        $new = $shipment->createShipment($input);
        http_response_code(201);
        echo json_encode($new);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to create shipment', 'message' => $e->getMessage()]);
    }
