<?php
    require_once __DIR__ . '/../../config/functions.php';
    require_once __DIR__ . '/../../classes/Shipment.php';
    require_once __DIR__ . '/../../middlewares/auth.php';
    
    authMiddleware();
    
    $data = json_decode(file_get_contents('php://input'), true);
    $shipmentId = (int)($_GET['shipment_id'] ?? 0);
    
    if (!$shipmentId) {
        http_response_code(400);
        echo json_encode(['error' => 'Shipment ID missing']);
        exit;
    }

    $status = $data['status'] ?? null;
    $location = $data['location'] ?? null;
    $description = $data['description'] ?? null;
    
    if (!$status) {
        http_response_code(400);
        echo json_encode(['error' => 'Status is required']);
        exit;
    }
    
    $shipmentObj = new Shipment();
    try {
        $event = $shipmentObj->addEventFromAdmin($shipmentId, $status, $location, $description);
        echo json_encode(['success' => true, 'event' => $event]);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['error' => $e->getMessage()]);
    }
