<?php
    require_once __DIR__ . '/../../config/functions.php';
    require_once __DIR__ . '/../../classes/Shipment.php';
    
    $tracking = $_GET['tracking'] ?? null;
    if (!$tracking) {
        http_response_code(400);
        echo json_encode(['error' => 'Tracking number required']);
        exit;
    }
    
    $shipmentObj = new Shipment();
    try {
        $s = $shipmentObj->getByTracking($tracking);
        if (!$s) {
            http_response_code(404);
            echo json_encode(['error' => 'Shipment not found']);
            exit;
        }
    
        $s['events'] = $shipmentObj->getEvents((int)$s['id']);
    
        echo json_encode($s);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode([
            'error' => 'Failed to fetch tracking',
            'message' => $e->getMessage()
        ]);
    }
