<?php
    require_once __DIR__ . '/../../config/functions.php';
    require_once __DIR__ . '/../../classes/Feedback.php';
    
    $feedback = new Feedback();
    $id = intval($_GET['id'] ?? 0);
    
    if (!$id) {
        http_response_code(400);
        echo json_encode(['error' => 'Feedback ID missing']);
        exit;
    }
    
    // Read JSON body
    $data = json_decode(file_get_contents('php://input'), true);
    $status = $data['status'] ?? null;
    $notes  = $data['notes'] ?? null;
    
    if (!$status) {
        http_response_code(400);
        echo json_encode(['error' => 'Status is required']);
        exit;
    }
    
    try {
        $updated = $feedback->updateStatus($id, $status, $notes);
        echo json_encode(['success' => true, 'feedback' => $updated]);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['error' => $e->getMessage()]);
    }
