<?php
    require_once __DIR__ . '/../../config/functions.php';
    require_once __DIR__ . '/../../classes/Feedback.php';
    
    if (!isset($_GET['id'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Missing feedback ID']);
        exit;
    }
    
    $id = (int)$_GET['id'];
    $feedback = new Feedback();
    
    try {
        $f = $feedback->getById($id);
        if (!$f) {
            http_response_code(404);
            echo json_encode(['error' => 'Feedback not found']);
            exit;
        }
        echo json_encode($f);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to fetch feedback', 'message' => $e->getMessage()]);
    }
