<?php
    require_once __DIR__ . '/../../config/functions.php';
    require_once __DIR__ . '/../../classes/Feedback.php';
    
    // POST only
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        http_response_code(405);
        echo json_encode(['error' => 'Method not allowed']); 
        exit;
    }
    
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input || !isset($input['name'], $input['email'], $input['rating'], $input['type'], $input['message'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Invalid request body']);
        exit;
    }
    
    $feedback = new Feedback();
    
    try {
        $ok = $feedback->createFeedback($input);
    
        if (!$ok) {
            http_response_code(400);
            echo json_encode(['error' => 'Feedback rejected']);
            exit;
        }
    
        echo json_encode(['success' => true, 'message' => 'Feedback received']);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to submit feedback']);
    }
