<?php
    require_once __DIR__ . '/../../config/functions.php';
    require_once __DIR__ . '/../../classes/Booking.php';
    require_once __DIR__ . '/../../middlewares/auth.php';
    require_once __DIR__ . '/../../middlewares/super_admin.php';
    
    // Verify JWT and get payload
    $userPayload = authMiddleware(); 
    
    // Ensure only super_admin can list all bookings
    superAdminMiddleware();
    
    $booking = new Booking();
    
    // Sanitize and set pagination & filters
    $id= isset($_GET['id']) ? (int)$_GET['id'] : null;
    $limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 50;
    $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
    $status = $_GET['status'] ?? null;
    
    try {
        // List bookings with optional status filter
        $bookings = $booking->list($id, $limit, $offset, $status);
        http_response_code(200);
        echo json_encode($bookings);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to list bookings']);
    }
