<?php
    require_once __DIR__ . '/../../config/functions.php';
    require_once __DIR__ . '/../../classes/AdminUser.php';
    require_once __DIR__ . '/../../middlewares/auth.php';
    require_once __DIR__ . '/../../middlewares/super_admin.php';

    superAdminMiddleware();

    $input = json_decode(file_get_contents('php://input'), true);
    $userId = $input['userId'];
    
    if (!isset($input['userId']) || !isset($input['old_password']) || !isset($input['new_password'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Invalid request, missing fields']);
        exit;
    }
    
    $adminUser = new AdminUser();
    
    // First: verify old password
    if (!$adminUser->verifyPassword($userId, $input['old_password'])) {
        http_response_code(401);
        echo json_encode(['error' => 'Old password is incorrect']);
        exit;
    }
    
    // Update password
    try {
        $adminUser->setPassword($userId, $input['new_password']);
        echo json_encode(['message' => 'Password updated']);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to update password']);
    }

