<?php
    require_once __DIR__ . '/../../config/functions.php';
    require_once __DIR__ . '/../../classes/AdminUser.php';
    require_once __DIR__ . '/../../classes/Auth.php';
    
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($input['email'], $input['password'])) {
        http_response_code(400);
        echo json_encode(['success' => false, 'code' => 400, 'error' => 'Email and password required']);
        exit; 
    }
    
    try {
        $admin = new AdminUser();
        $user = $admin->login($input['email'], $input['password']);
        
        if (!$user) {
            http_response_code(401);
            echo json_encode(['success' => false, 'code' => 401, 'error' => 'Invalid credentials']);
            exit;
        }
    } catch(Exception $e) {
        http_response_code(401);
        echo json_encode([
            'success' => false,
            'code' => 401,
            'error' => $e->getMessage(),
        ]);
        exit;
    } catch(PDOException $e) {
        http_response_code(500);
        echo json_encode([
            'success' => false,
            'code' => 500,
            'error' => $e->getMessage(),
        ]);
        exit;
    }
    
    $auth = new Auth();
    $token = $auth->generateToken($user);
    
    // GO-STYLE RESPONSE
    echo json_encode([
        'success' => true,
        'code' => 0,
        'token' => $token,
        'user' => [
            'id' => $user['id'],
            'email' => $user['email'],
            'role' => $user['role'],
            'full_name' => $user['full_name']
        ]
    ]);
